<?php

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Products Page</title>
    <!-- <link rel="stylesheet" href="assests/css/style.css"> -->
    <link rel="stylesheet" href="assests/css/category.css">

      <!-- Bootstrap link -->
      <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
</head>

<body>
    <h1 class="mobile-text text-center">Change to Mobile VIew</h1>
    <!-- <div class="page-head" id="page-head">
        <div class="row">
            <div class="col-md-6">
                <div class="logo">hapi <span class="taplogo">tap</span></div>
            </div>
        </div>
    </div> -->
    <div class="add-category">
        <div class="row">
            <div class="col-md-12 d-flex align-items-center">
                <i class="fa fa-arrow-left" onclick="window.location='dashboard.php'"></i> <span class="text-span">Add New Category</span>
            </div>            
        </div>
    </div>

    <div class="cate-image d-flex align-items-center justify-content-center">
    <div class="row">
        <div class="col-md-4"></div>
        <div class="col-md-4 d-flex text-center align-items-center justify-content-center">
            <div class="image-container" style="margin-left: 20px;">
                <input type="file" accept="image/*" name="image" id="imageInput" style="display: none;">
                <label for="imageInput" class="custom-file-upload">
                    <img src="" alt="Selected Image" class="selected-image" id="selectedImage" style="display: none;">
                    <span class="plus-icon"><i class="fa fa-plus"> <br>Add Image</i></span>
                </label>    
            </div>
            <span class="remove-image" id="removeImage" style="display: none;">-</span>
        </div>
        <div class="col-md-4"></div>
    </div>
</div>



<div class="input-text">
    <input type="text" id="categoryName" class="" placeholder="Category Name">
    <br><br>
    <input type="text" id="gmcCategory" class="" placeholder="GMC Category">
</div>

<div class="button-save">
    <button class="btn btn-primary" id="saveBtn"><i class='fa fa-save'></i>  &nbsp;&nbsp;Save</button>
</div> 

        


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

			
    <script>
	document.addEventListener('DOMContentLoaded', function() {
		const input = document.getElementById('imageInput');
		const img = document.getElementById('selectedImage');
		const plusLabel = document.querySelector('.plus-icon');
		const removeBtn = document.getElementById('removeImage');
		const fileInput = document.querySelector('.custom-file-upload');

		input.addEventListener('change', function(event) {
			const file = event.target.files[0];
			const reader = new FileReader();

			reader.onload = function(event) {
				img.src = event.target.result;
				img.style.display = 'block';
				plusLabel.style.display = 'none'; 
				removeBtn.style.display = 'block';
				fileInput.style.border = 'none';
			};

			reader.readAsDataURL(file);
		});

		removeBtn.addEventListener('click', function() {
			img.src = '';
			img.style.display = 'none';
			plusLabel.style.display = 'block'; // Show the plus icon
			removeBtn.style.display = 'none';
			fileInput.style.border = '1px solid blue';
			input.value = ''; // Clear the input value
		});
	});
</script>
<script>
$(document).ready(function () {
    

    // Handle Save Button Click
    $("#saveBtn").on("click", function () {
        console.log("Save button clicked");  // Debug line
        var categoryName = $("input[placeholder='Category Name']").val();
        var gmcCategory = $("input[placeholder='GMC Category']").val();
        var imageFile = $("#imageInput")[0].files[0];

        // Validate the form fields
        if (!categoryName || !gmcCategory || !imageFile) {
            alert("Please fill out all fields and select an image.");
            return;
        }

        // Create a FormData object to handle file upload
        var formData = new FormData();
        formData.append("category", categoryName);
        formData.append("gmccategory", gmcCategory);
        formData.append("image", imageFile);

        console.log("Form data prepared: ", formData);  // Debug line
        console.log("Image file: ", imageFile);  // Debug line

        // Send AJAX request
        $.ajax({
            url: "savecategory.php",  // Path to PHP script
            type: "POST",
            data: formData,
            contentType: false,  // Let jQuery set content-type
            processData: false,  // Don't process data
            dataType: "json",  // Expect JSON response 
            success: function (data) {
                console.log(data);  // Log server response for further debugging
                if (data.success) {
                    window.location = 'dashboard.php';
                } else {
                    alert("Error: " + data.message);
                }
            },
            error: function (xhr, status, error) {
                console.error("AJAX request failed:", error);
                alert("An error occurred while saving the category.");
            }
        });
    });
});

</script>
</body>
</html>